<?php

namespace Admin\Controller;

use Think\Model;
/*
 * 充值
 */
class ChargeController extends AdminController {

    /**
     * 列表
     */
    public function rule(){
        $keywords = I('keywords');
        $map['status'] = array('in','1,0,-1');
        if(!empty($keywords)){
            $map['title']    =   array('like', '%'.(string)$keywords.'%');
        }

        $list   = $this->lists('ChargeRule', $map);
        int_to_string($list);
        
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->meta_title = 'Charging rule';
        $this->display();
    }


    /*
     * 编辑
    */
    public function rule_edit(){
    	if(IS_POST){
    		$this->save('ChargeRule','rule');

    	} else {
    		$info = $this->getInfo('ChargeRule');

    		$this->assign('info',$info);
    		$this->meta_title = empty($info)? 'New charging rule':'Edit charging rule' ;
    		$this->display();
    	}
    }
    
    
    /**
     * 充值记录
     */
    public function chargeLog(){
        $p = I('p',1);
        $pay_status = I('pay_status','');
        $demo = 1;
        $keywords = I('keywords','');
        if($keywords)
            $map['mobile'] = array('like',"%$keywords%");
    
        if(!empty($pay_status)){
            switch ($pay_status){
                case 'no_pay':
                    $map['pay_status'] = 0;
                    break;
                case 'has_pay':
                    $map['pay_status'] = 1;
                    break;
                default:
                    break;
            }
        }
    
        $map['status'] = array('egt',0);
        if(UID!=26){
            $map['is_fault'] = 0;
            $demo = 0;
        }
        $list   = $this->lists('ChargeMember', $map, 'createtime desc');
    
        $pay_total = M('OrderCharge')->where($map)->sum('pay_fee');
    
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->assign('pay_status', $pay_status);
        $this->assign('pay_total', $pay_total);
        $this->assign('p', $p);
        $this->assign('demo', $demo); //是为演示数据
        $this->meta_title = 'Recharge list';
        $this->display();
    }
    
    
}