<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Controller;


class AgentController extends AdminController {

    /**
     * 列表
     */
    public function index(){
        $keywords       =   I('keywords');
        $map['status'] = array('in','1,0,-1');
        if(!empty($keywords)){
            $map['title|phone|linkman']    =   array('like', '%'.(string)$keywords.'%');
        }

        $list   = $this->lists(CONTROLLER_NAME, $map);
        int_to_string($list);
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->meta_title = 'Agent List';
        $this->display('index');
    }


    /*
     * 编辑
    */
    public function edit(){
    	if(IS_POST){
    	    clearCache();
    		$model = D('Agent');
    		if($data=$model->create()){
    			if($data['id']){
    				$status = $model->save($data);
    			}else{
    				$status = $model->add($data);
    			}
    			if($status){
    				clearCache();
    				$this->success('Modified success',U('index'));

    			}else{
    				$message = $model->getError();
    				$this->error($message);
    			}

    		}else{
    			$message = $model->getError();
    			$this->error($message);
    		}

    	} else {
    		$info = $this->getInfo(CONTROLLER_NAME);

    		$this->assign('info',$info);
    		$this->meta_title = empty($info)? 'New agents':'Edit Agent' ;
    		$this->display();
    	}
    }


}