<?php

namespace Admin\Controller;

use Think\Model;
use Common\Model\MemberModel;
/*
 * 优惠券
 */
class CouponController extends AdminController {

    /**
     * 列表
     */
    public function index(){
        $keywords = I('keywords');
        $mid = I('mid',0);
        $map['status'] = array('in','1,0,-1');
        if(!empty($keywords)){
            $map['title']    =   array('like', '%'.(string)$keywords.'%');
        }
        if(!empty($mid)){
            $map['mid']    =   $mid;
        }

        $list   = $this->lists(CONTROLLER_NAME, $map);
        int_to_string($list);
        
        $mchList = $this->getAllRows('Merchant',true,array('status'=>1));
        
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->assign('mchList', $mchList);
        $this->assign('mid', $mid);
        $this->meta_title = 'Coupon list';
        $this->display('index');
    }


    /*
     * 编辑
    */
    public function edit(){
    	if(IS_POST){
    	    $money = I('money',0);
    	    $order_total = I('order_total',0);
    	    if(!is_numeric($money)){
    	        $this->error('The amount of coupons was incorrectly filled in');
    	    }
    	    if(!is_numeric($order_total)){
    	        $this->error('format error');
    	    }
    	    
    		$this->save(CONTROLLER_NAME,'index');

    	} else {
    		$info = $this->getInfo(CONTROLLER_NAME);
    		$merchants = $this->lists('Merchant',array('status'=>1),'id desc',true,10000);
    		
    		$goodsList = array();
    		if($info['mid']){
    		    $map['status'] = 1;
    		    $map['mid'] = $info['mid'];
    		    $goodsList = $this->getAllRows('Goods',true,$map);
    		}

    		$this->assign('info',$info);
    		$this->assign('merchants',$merchants);
    		$this->assign('goodsList',$goodsList);
    		$this->meta_title = empty($info)? 'New Coupon':'Edit Coupon' ;
    		$this->display();
    	}
    }
    
    
    /*
     * 加载商品
     */
    public function loadGoods(){
        $mid = I('mid',0);
        
        $map['status'] = 1;
        $map['mid'] = $mid;
        $lists = $this->getAllRows('Goods',true,$map);
        
        $this->apiReturn(1,'succ',$lists);
    }
    
    
    /*
     * 后台给会员发送优惠券
     */
    public function send($id=0) {
        $coupon_id = I('coupon_id',0);
        $info = M('Coupon')->find($coupon_id);
        
        if(IS_POST){
            
            $mobile = I('mobile','');
            $token = I('token','');
    
            $local_token = S('form_token');
            if($token==$local_token){
                $this->error('Do not repeat submission'); //请勿重复提交
            }else{
                S('form_token',$token);
            }
    
            $obj_mem = new MemberModel();
            $memInfo = $obj_mem->getInfoByMobile($mobile);
            if(!$memInfo){
                $this->error('Non-existent users'); //不存在的用户
            }

            $map['userid']=$memInfo['id'];
            $map['coupon_id']=$coupon_id;
            $count = M('MemberCoupon')->where($map)->count(); //计算已给给用户发放了几张
            
            if($count>=$info['limit_num']){
                $this->error('Over the amount available'); //已超出可领的数量
            }
                        
            $data['userid'] = $memInfo['id'];
            $data['mid'] = $info['mid'];
            $data['title'] = $info['title'];
            $data['goods_id'] = $info['goods_id'];
            $data['money'] = $info['money'];
            $data['order_total'] = $info['order_total'];
            $data['coupon_id'] = $coupon_id;
            $data['expire_time'] = time()+$info['expire_date']*86400;
            $data['update_time'] = time();
            $data['status'] = 0;
    
            $res = M('MemberCoupon')->add($data);
            if($res){
                M('Coupon')->where('id='.$coupon_id)->setInc('send_num');
                $this->success('present success'); //发放成功
            }else{
                $this->error('present failed'); //发放失败
            }
    
        } else {
            $this->assign('info',$info);
            $this->assign('token',md5(time()));
            $this->display();
        }
    }


}