<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Controller;
use User\Api\UserApi;

/**
 * 后台首页控制器
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class PublicController extends \Think\Controller {

    /**
     * 后台用户登录
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function login($username = null, $password = null, $verify = null){
        if(IS_POST){
            /* 检测验证码 TODO: */
            if(!check_verify($verify)){
                $this->error('Verification code error！'); //验证码输入错误
            }
            if (!$username) {
                $this->error('Please enter the username');
           }
           if (!$password) {
                $this->error('Please enter the password');
           }
           $info = D('Manager')->login($username,$password);
           if ($info['id'] > 0) {
                $this->success('Login success',U('Index/index'));
           }else{
                $this->error($info['msg']);
           }
        } else {
            if(is_login()){
                $this->redirect('Index/index');
            }else{
                /* 读取数据库中的配置 */
                $config =   S('DB_CONFIG_DATA');
		        if(!$config){
		        	$config   = D('Config')->detail();
		            S('DB_CONFIG_DATA',$config);
		        }
		        C($config); //添加配置
                
                $this->display();
            }
        }
    }

    /* 退出登录 */
    public function logout(){
        if(is_login()){
            D('Manager')->logout();
            session('[destroy]');
            $this->success('Logout success！', U('login'));
        } else {
            $this->redirect('login');
        }
    }

    public function verify(){
        $verify = new \Think\Verify();
        $verify->length   = 4;
        $verify->codeSet = '0123456789';
        $verify->entry(1);
    }
    
    public function test(){
        echo pwd_md5('111', AUTH_KEY);
    }
    
    public function map(){
    	$this->display();
    }

}
