<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Admin\Model;
use Think\Model;

/**
 * 充值规则模型
 */
class ChargeRuleModel extends Model{

    protected $_validate = array(
        array('title', 'require', 'Title cannot be empty', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    );

    protected $_auto = array(
        array('create_time', NOW_TIME, self::MODEL_INSERT),
        array('update_time', NOW_TIME, self::MODEL_BOTH),
        array('status', '1', self::MODEL_BOTH),
    	array('pay_fee', 'checkPayfee', 'Incorrect filling format of recharge amount', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
        array('gift_fee', 'checkGiftfee', 'The format of the gift amount is wrong', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
    );


    /* 充值金额填写格式 */
    public function checkPayfee($value){
    	return is_numeric($value);

    }
    
    /* 赠送金额填写格式 */
    public function checkGiftfee($value){
        return is_numeric($value);
    
    }



}
