<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com>
// +----------------------------------------------------------------------

namespace Admin\Model;
use Think\Model;
/**
 * 配置模型
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */

class ConfigModel extends Model {
    protected $_validate = array(
    	array('min_amount', 'check_min_amount', 'Please fill in the number', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
    	array('jifen_ratio', 'check_jifen_ratio', 'Please fill in the number', self::MUST_VALIDATE , 'callback', self::MODEL_BOTH),
    );

    protected $_auto = array(
        array('create_time', NOW_TIME, self::MODEL_INSERT),
        array('update_time', NOW_TIME, self::MODEL_BOTH),
        array('status', '1', self::MODEL_BOTH),
    );

    /* 检查起洗价 */
    public function check_min_amount($value){
    	return is_numeric($value);

    }
    /* 检查积分比例 */
    public function check_jifen_ratio($value){
    	return is_numeric($value);

    }

    /**
     * 获取配置
     * @return array 配置数组
     */
    public function detail(){
        $data   = $this->find(1);

        return $data;
    }



}
