<?php

namespace Admin\Model;
use Think\Model;

/**
 * 柜机模型
 */
class MachineModel extends Model{

    protected $_validate = array(
        array('title', '1,26', '柜机名名称', self::EXISTS_VALIDATE, 'length'),
    	array('serial_no', 'require', '柜机编号不能为空', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
        array('serial_no', '', '柜机编号被占用', self::EXISTS_VALIDATE, 'unique'),
        array('machine_id', 'require', '硬件ID不能为空', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
        array('machine_id', '', '硬件ID被占用', self::EXISTS_VALIDATE, 'unique'),
    	array('pwd', 'require', '管理员取件密码不能为空', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
        array('fac_id', 'require', '请选择洗衣厂', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    );

    protected $_auto = array(
        array('create_time', NOW_TIME, self::MODEL_INSERT),
        array('update_time', NOW_TIME, self::MODEL_BOTH),
    	array('status', '1', self::MODEL_INSERT),
    );

}
