<?php

namespace Api\Controller;
use Think\Controller;
use Admin\Model\ConfigModel;
/**
 * 接口公共类控制器
 */
class PublicController extends Controller {
	protected $mac_id;
	protected $fac_id;
	protected $mid;
	protected $agent_id;
	protected $uuid;

    /**
     * 控制器初始化
     */
    protected function _initialize(){

        $action = I('action','rest');
        $action_arr = array('qrcode','init');
    	if(!in_array($action, $action_arr)){
	    	//校验合法性
	    	$token = I('token','');
	    	$serial_no = I('serial_no','');
	    	$action = I('action','');
	    	$local_token = md5($action.AUTH_KEY.date('Ymd'));
// 	    	if($token!=$local_token){
// 	    		$this->error('校验失败','',true);

// 	    	}


	    	if(!$serial_no){
	    		$this->error(L('out_of_service'),'',true);
	    	}

	    	$map['serial_no'] = $serial_no;
	    	$map['status'] = 1;
	    	$machine = M('Machine')->where($map)->find();
	    	if(!$machine){
	    		$this->error(L('out_of_service'),'',true);
	    	}
	    	$this->mac_id = $machine['id'];
	    	$this->fac_id = $machine['fac_id'];
	    	$this->mid = $machine['mid'];
	    	$this->agent_id = $machine['agent_id'];
	    	$this->uuid = $serial_no;
    	}

        /* 读取数据库中的配置 */
//         $config =   S('DB_CONFIG_DATA');
        if(!$config){
        	$obj_config = new ConfigModel();
        	$config   = $obj_config->detail();
            S('DB_CONFIG_DATA',$config);
        }
        C($config); //添加配置

    }



    /**
     * 通用分页列表数据集获取方法
     *
     *  可以通过url参数传递where条件,例如:  index.html?name=asdfasdfasdfddds
     *  可以通过url空值排序字段和方式,例如: index.html?_field=id&_order=asc
     *  可以通过url参数r指定每页数据条数,例如: index.html?r=5
     *
     * @param sting|Model  $model   模型名或模型实例
     * @param array        $where   where查询条件(优先级: $where>$_REQUEST>模型设定)
     * @param array|string $order   排序条件,传入null时使用sql默认排序或模型属性(优先级最高);
     *                              请求参数中如果指定了_order和_field则据此排序(优先级第二);
     *                              否则使用$order参数(如果$order参数,且模型也没有设定过order,则取主键降序);
     *
     * @param boolean      $field   单表模型用不到该参数,要用在多表join时为field()方法指定参数
     * @author 朱亚杰 <xcoolcc@gmail.com>
     *
     * @return array|false
     * 返回数据集
     */
    protected function lists ($model,$where=array(),$order='',$field=true,$limit=30 ){
    	$options    =   array();
    	$REQUEST    =   (array)I('request.');
    	if(is_string($model)){
    		$model  =   M($model);
    	}

    	$OPT        =   new \ReflectionProperty($model,'options');
    	$OPT->setAccessible(true);

    	$pk         =   $model->getPk();
    	if($order===null){
    		//order置空
    	}else if ( isset($REQUEST['_order']) && isset($REQUEST['_field']) && in_array(strtolower($REQUEST['_order']),array('desc','asc')) ) {
    		$options['order'] = '`'.$REQUEST['_field'].'` '.$REQUEST['_order'];
    	}elseif( $order==='' && empty($options['order']) && !empty($pk) ){
    		$options['order'] = $pk.' desc';
    	}elseif($order){
    		$options['order'] = $order;
    	}
    	unset($REQUEST['_order'],$REQUEST['_field']);

    	if(empty($where)){
    		$where  =   array('status'=>array('egt',0));
    	}
    	if( !empty($where)){
    		$options['where']   =   $where;
    	}
    	$options      =   array_merge( (array)$OPT->getValue($model), $options );
    	$total        =   $model->where($options['where'])->count();

    	if($limit)
    		$listRows = $limit;
    	else{
    		if( isset($REQUEST['r']) ){
    			$listRows = (int)$REQUEST['r'];
    		}else{
    			$listRows = C('LIST_ROWS') > 0 ? C('LIST_ROWS') : 10;
    		}
    	}
    	$page = new \Think\Page($total, $listRows, $REQUEST);
    	if($total>$listRows){
    		$page->setConfig('theme','%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%');
    	}
    	$p =$page->show();
    	$this->assign('_page', $p? $p: '');
    	$this->assign('_total',$total);
    	$options['limit'] = $page->firstRow.','.$page->listRows;

    	$model->setProperty('options',$options);

    	return $model->field($field)->select();
    }


    /**
     * 获取单条具体信息
     * @param string $obj 对象名称 默认当前控制器名称
     * @author tang
     */
    function getInfo($obj = CONTROLLER_NAME,$id){
    	$info = array();
    	$model = M($obj);
    	$info = $model->find($id);
    	return $info;
    }


    /**
     * 获取数量
     * @param string $obj 对象名称 默认当前控制器名称
     * @param map $map 查询条件
     * @author tang
     */
    function getCount($obj = CONTROLLER_NAME,$map=array()){
    	$count = 0;
    	if($obj){
    		$model = M($obj);
    		$count = $model->where($map)->count();
    	}
    	return $count;
    }


    /*
     * 生成二维码
     */
    public function qrcode($data){
    	require_once VENDOR_PATH.'phpqrcode.php';
    	$url = urldecode($data);
    	\QRcode::png($url);
    }





}
