<?php

namespace Common\Model;
use Think\Model;

/**
 * 订单模型
 */
class OrderGoodsModel extends Model{

    protected $_validate = array(
    	array('out_trade_no', 'require', '{%order_num_empty}', self::MUST_VALIDATE , 'regex', self::MODEL_BOTH),
    );

    protected $_auto = array(
        array('createtime', NOW_TIME, self::MODEL_INSERT),
    	array('status', '1', self::MODEL_INSERT),
    );


    public function saveGoods($order){
        $goods_arr = json_decode($order['body'],true);
    	
    	foreach ($goods_arr as $k=>$g){    	    
    		$goods = array();
    		$goods['goods_id'] = $g['id'];
    		$goods['goods_number'] = $g['num'];
    		$goods['goods_name'] = $g['title'];
    		$goods['goods_price'] = $g['price'];
    		$goods['goods_cate'] = $g['cate'];
    		
    		$goods['out_trade_no'] = $order['out_trade_no'];
    		$goods['userid'] = $order['userid'];
    		$goods['mac_id'] = $order['mac_id'];
    		$goods['agent_id'] = $order['agent_id'];
    		$goods['fac_id'] = $order['fac_id'];
    		$goods['mid'] = $order['mid'];
    		$goods['createtime'] = $order['createtime'];
    		$goods['status'] = 1;
    		
    		$this->add($goods);

    	}
    	
    }


    public function getInfo($key,$value){
    	return $this->where(array($key=>$value))->find();
    }





}
