<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Factory\Controller;

use Admin\Model\ConfigModel;
/**
 * 后台首页控制器
 * @author 麦当苗儿 <zuojiazi@vip.qq.com>
 */
class PublicController extends \Think\Controller {

    /**
     * 后台用户登录
     * @author 麦当苗儿 <zuojiazi@vip.qq.com>
     */
    public function login($username = null, $password = null, $verify = null){
        if(IS_AJAX){
            /* 检测验证码 TODO: */
            /*
        	if(!check_verify($verify)){
                $this->error('验证码输入错误！');
            }
            */
            if (!$username) {
                $this->error('Please enter the username');
           }
           if (!$password) {
                $this->error('Please enter the password');
           }
           $info = D('Factory')->login($username,$password);
           if ($info['uid'] > 0 && $info['status']) {
                $this->success('Login success',U('Index/index'));
           }else{
                $this->error($info['msg']);
           }
        } else {
            if(is_login()){
                $this->success('You are logged in',U('Index/index'));
            }else{
                /* 读取数据库中的配置 */
                $config =   S('DB_CONFIG_DATA');
		        if(!$config){
		        	$obj_config = new ConfigModel();
		        	$config   = $obj_config->detail();
		            S('DB_CONFIG_DATA',$config);
		        }
		        C($config); //添加配置

                $this->display();
            }
        }
    }

    /* 退出登录 */
    public function logout(){
        if(is_login()){
            D('Factory')->logout();
            session('[destroy]');
            $this->success('Logout success！', U('login'));
        } else {
            $this->redirect('login');
        }
    }

    public function verify(){
        $verify = new \Think\Verify();
        $verify->length   = 4;
        $verify->codeSet = '0123456789';
        $verify->entry(1);
    }


    /*
     * 从总后台跳转到用户后台
     */
    public function route($mid=0,$token=''){
    	if(!$mid && !$token)
    		die('Illegal operation: empty parameter');
    	$local_token = think_encrypt(date('Y-m-d'));
    	if ($local_token!=$token) {
    		die('Illegal operation: verification failed');
    	}
    	$user = M('Factory')->find($mid);
    	if(!$user){
    		die('Illegal operation: non-existent user');
    	}

    	/* 记录登录SESSION和COOKIES */
    	$auth = array(
    			'uid'             => $user['id'],
    			'username'        => $user['username'],
    			'last_login_time' => $user['last_login_time'],
    	);

    	session('factory_auth', $auth);
    	session('factory_auth_sign', data_auth_sign($auth));

    	header('Location:'.U('Index/index'));

    }

}
