<?php
// +----------------------------------------------------------------------
// | OneThink [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2013 http://www.onethink.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: 麦当苗儿 <zuojiazi@vip.qq.com> <http://www.zjzit.cn>
// +----------------------------------------------------------------------

namespace Home\Controller;

use Think\Controller;
use Admin\Model\ConfigModel;

/**
 * 前台公共控制器
 * 为防止多分组Controller名称冲突，公共Controller名称统一使用分组名称
 */
class HomeController extends Controller
{

	protected function _initialize()
	{

		/* 读取数据库中的配置 */
		//$config =   S('DB_CONFIG_DATA');
//		die('xxx');
		if (!$config) {
			$obj_config = new ConfigModel();
			$config = $obj_config->detail();
			S('DB_CONFIG_DATA', $config);
		}
		C($config); //添加配置

	}


	/**
	 * 通用分页列表数据集获取方法
	 *
	 *  可以通过url参数传递where条件,例如:  index.html?name=asdfasdfasdfddds
	 *  可以通过url空值排序字段和方式,例如: index.html?_field=id&_order=asc
	 *  可以通过url参数r指定每页数据条数,例如: index.html?r=5
	 *
	 * @param sting|Model $model 模型名或模型实例
	 * @param array $where where查询条件(优先级: $where>$_REQUEST>模型设定)
	 * @param array|string $order 排序条件,传入null时使用sql默认排序或模型属性(优先级最高);
	 *                              请求参数中如果指定了_order和_field则据此排序(优先级第二);
	 *                              否则使用$order参数(如果$order参数,且模型也没有设定过order,则取主键降序);
	 *
	 * @param boolean $field 单表模型用不到该参数,要用在多表join时为field()方法指定参数
	 * @return array|false
	 * 返回数据集
	 * @author 朱亚杰 <xcoolcc@gmail.com>
	 *
	 */
	protected function lists($model, $where = array(), $order = '', $field = true, $limit = 10)
	{
		$options = array();
		$REQUEST = (array)I('request.');
		if (is_string($model)) {
			$model = M($model);
		}

		$OPT = new \ReflectionProperty($model, 'options');
		$OPT->setAccessible(true);

		$pk = $model->getPk();
		if ($order === null) {
			//order置空
		} else if (isset($REQUEST['_order']) && isset($REQUEST['_field']) && in_array(strtolower($REQUEST['_order']), array('desc', 'asc'))) {
			$options['order'] = '`' . $REQUEST['_field'] . '` ' . $REQUEST['_order'];
		} elseif ($order === '' && empty($options['order']) && !empty($pk)) {
			$options['order'] = $pk . ' desc';
		} elseif ($order) {
			$options['order'] = $order;
		}
		unset($REQUEST['_order'], $REQUEST['_field']);

		if (empty($where)) {
			$where = array('status' => array('egt', 0));
		}
		if (!empty($where)) {
			$options['where'] = $where;
		}
		$options = array_merge((array)$OPT->getValue($model), $options);
		$total = $model->where($options['where'])->count();

		if (isset($REQUEST['r'])) {
			$listRows = (int)$REQUEST['r'];
		} else {
			$listRows = C('LIST_ROWS') > 0 ? C('LIST_ROWS') : 10;
		}
		$page = new \Think\Page($total, $listRows, $REQUEST);
		if ($total > $listRows) {
			$page->setConfig('theme', '%FIRST% %UP_PAGE% %LINK_PAGE% %DOWN_PAGE% %END% %HEADER%');
		}
		$p = $page->show();
		$this->assign('_page', $p ? $p : '');
		$this->assign('_total', $total);
		$options['limit'] = $page->firstRow . ',' . $page->listRows;

		$model->setProperty('options', $options);

		return $model->field($field)->select();
	}


	/**
	 * 获取单条具体信息
	 * @param string $obj 对象名称 默认当前控制器名称
	 * @author tang
	 */
	function getInfo($obj = CONTROLLER_NAME, $id = 'id', $rela = false)
	{
		$info = array();
		$model = M($obj);
		if ($rela) {
			$model = D($obj)->relation(true);
		}
		$info = $model->find($id);
		return $info;
	}

	// 获取所有记录
	function getAllRows($model = CONTROLLER_NAME, $field = '', $map = array(), $order = 'id desc')
	{
		$map['status'] = array('egt', 0);
		return M($model)->field($field)->where($map)->order($order)->select();
	}

	// 设置字段值
	function setField()
	{
		$id = I('get.id', 0) > 0 ? I('get.id') : I('ids');
		$model = I('get.model', CONTROLLER_NAME);
		$field = I('get.field', 'status');
		$value = I('get.val', 0);
		$data[$field] = $value;
		$model = M($model);
		$map['id'] = array('in', $id);
		if ($model->where($map)->save($data)) {
			$this->success('Operation succeeded', U('index'));
		} else {
			$this->error('Server error');
		}

	}

}
