<?php


namespace Home\Controller;

use Common\Model\MemberModel;
use Org\Check;
use Org\Vcode;
use Org\Sms;
use Home\Model\OrderModel;

/**
 * 前台控制器
 */
class IndexController extends HomeController
{
	protected $userid;
	protected $source = '';
	protected $unionid = '';

	public function _initialize()
	{
		parent::_initialize();

		$action_arr = array('index', 'about', 'contact');

		if (!in_array(ACTION_NAME, $action_arr)) {
			$this->source = 'line';
			$this->unionid = getLineID();
// 			elseif (Check::isWeixin()){
// 				$this->source = 'weixin';
// 				$this->unionid = getOpenID();
// 			}elseif (Check::isAlipay()){
// 				$this->source = 'alipay';
// 				$this->unionid = getAlipayID();
			//}else{
			//exit('please open in line');
			//}
		}


		//echo $this->unionid;exit();

//  		$this->unionid = '2088102171629029';

// 		$this->source = 'line';
// 		$this->unionid = '1625403020';

		$action_arr = array('index', 'about', 'contact', 'bind', 'sendVcode', 'machine', 'machine_load2');
		if (!in_array(ACTION_NAME, $action_arr)) {
			$obj_mem = new MemberModel();
			$memInfo = $obj_mem->getInfoByUnionid($this->unionid, $this->source);
			if (!$memInfo || !$memInfo['mobile']) {//未绑定手机号，去绑定
				$pre_url = $_SERVER['REQUEST_URI'];
				session('pre_url', $pre_url);
				session('action', ACTION_NAME);
				redirect(U('bind'));
				exit;
			} else if ($memInfo['status'] != 1) {
				exit(L('account_error'));
			} else {
				$this->userid = $memInfo['id'];
			}
		}
	}


	//首页
	public function index()
	{
//     	echo $this->unionid;
//         echo 'index';

        redirect(U('machine'));
		$this->meta_title = 'ทดลองซักอบรีด กับ Easywash24  กดที่ รูปภาพ';
		//redirect(U('machine'));
		$this->display();
	}


	//关于我们
	public function about()
	{
		$this->meta_title = L('about_us');
		$this->display();
	}

	//联系我们
	public function contact()
	{
		$this->meta_title = L('contact_us');
		$this->display();
	}


	//附近的设备
	public function machine()
	{

		$this->meta_title = L('machine_list');
		$this->display();
	}


	//设备列表ajax加载
	public function machine_load()
	{
		$result = array('succ' => 1, 'msg' => '', 'data' => '');
		$latitude = I('lat', 36.668900);
		$longitude = I('lng', 116.892920);

		$list = array();
		$Model = new \Think\Model();
		/*
		$sql = "
		select id,title, ROUND(6378.138*2*ASIN(SQRT(POW(SIN(($latitude*PI()/180-lat*PI()/180)/2),2)+COS($latitude*PI()/180)*COS(lat*PI()/180)*POW(SIN(($longitude*PI()/180-lng*PI()/180)/2),2)))*1000)
		as distance from ot_machine
		where status=1 having distance<100000
		order by distance asc limit 0,10
		";*/
		$sql = "
    	select id,title, ROUND(6378.138*2*ASIN(SQRT(POW(SIN(($latitude*PI()/180-lat*PI()/180)/2),2)+COS($latitude*PI()/180)*COS(lat*PI()/180)*POW(SIN(($longitude*PI()/180-lng*PI()/180)/2),2)))*1000)
    	as distance from ot_machine
    	where status=1
    	order by distance asc limit 0,20
    	";
		$list = $Model->query($sql);

		if (!empty($list)) {
			foreach ($list as $k => $v) {
				$map['mac_id'] = $v['id'];
				$map['is_used'] = 0;
				$num = M('machine_box')->where($map)->count();
				if ($num > 0)
					$list[$k]['box_num'] = $num;
				$list[$k]['url'] = U('machineDetail?id=' . $v['id']);
			}
		}

		$result['data'] = $list;

		$this->ajaxReturn($result);
	}


	//设备列表ajax加载2
	public function machine_load2()
	{
		$result = array('succ' => 1, 'msg' => '', 'data' => '');

		$list = array();
		$Model = new \Think\Model();

		$sql = "select * from ot_machine where status=1 order by id desc limit 0,20";
		$list = $Model->query($sql);

		if (!empty($list)) {
			foreach ($list as $k => $v) {
				$map['mac_id'] = $v['id'];
				$map['is_used'] = 0;
				$num = M('machine_box')->where($map)->count();
				if ($num > 0)
					$list[$k]['box_num'] = $num;
				$list[$k]['url'] = U('yuyue?id=' . $v['id']);
			}
		}

		$result['data'] = $list;

		$this->ajaxReturn($result);
	}

	//设备详情页
	public function machineDetail($id = 0)
	{
		$info = $this->getInfo('Machine', $id);
		$this->assign('info', $info);
		$this->meta_title = L('machine_detail');
		$this->display();
	}

	//预约下单页面
	public function yuyue($id = 0)
	{


		if (IS_POST) {


			$goods_arr = array();
			foreach ($_POST as $k => $v) {
				if (strstr($k, 'goods_') && $v > 0) {
					$id = str_replace('goods_', '', $k);
					$goodsInfo = M('goods')->find($id);

					$goods_arr[] = array(
						'id'     => str_replace('goods_', '', $k),
						'num'    => $v,
						'title'  => $goodsInfo['title'],
						'cate'   => $goodsInfo['cate'],
						'amount' => $goodsInfo['price'] * $v
					);
				}
			}
			if (empty($goods_arr)) {
				$this->error(L('select_laundry'), '', true);
			} else {
				S('goods_' . $this->userid, $goods_arr);
				$this->success(L('submit_ok'), U('confirm'), true);
			}
//     		print_pre($goods_arr);
//     		exit;

		} else {

			session('mac_id', $id);
			$macInfo = M('Machine')->find($id);
			// $mid = $macInfo['id'];
			$mid = $macInfo['mid'];


			$cates = M('category')->where(array('mid' => $mid, 'status' => 1))->select();
			$goods = array();
			foreach ($cates as $v) {
				$goods[$v['id']] = M('goods')->where(array('cate' => $v['id'], 'status' => 1))->order('sort desc')->select();

			}

// 	    	print_pre($cates);
// 	    	print_pre($goods);
// 	    	exit;

			$this->assign('cates', $cates);
			$this->assign('goods_arr', $goods);
			$this->assign('cates_num', count($cates));

			$this->meta_title = L('online_booking');
			$this->display();
		}
	}

	//确认订单页面
	public function confirm($out_trade_no = '')
	{
		$from_machine = 0;//是否从柜机过来的

		

		$out_trade_no = I('out_trade_no', '');
		
		if (!$out_trade_no) {//订单号不存在，微信端提交过来的
			$goods_cache = 'goods_' . $this->userid;
			$mac_id = session('mac_id');

		} else {//订单号已存在，柜机扫码过来的

			//判断订单是否已提交
			$orderInfo = M('Order')->where(array('out_trade_no' => $out_trade_no))->find();
			if (!$orderInfo) {//还未创建
				$goods_cache = $out_trade_no . '_goods'; //缓存的衣物明细
				$mac_id = S($out_trade_no . '_mac_id'); //缓存的柜机id
				$from_machine = 1;
			} else {//已创建
				if ($orderInfo['pay_status'] == 1) {//已支付，跳转到详情页
					$url = U('order_detail?id=' . $orderInfo['id']);
				} else {//未支付，跳转到支付页
					if ($this->source == 'weixin')
						$url = U('pay?out_trade_no=' . $orderInfo['out_trade_no']);
					elseif ($this->source == 'alipay')
						$url = U('pay_alipay?out_trade_no=' . $orderInfo['out_trade_no']);
					elseif ($this->source == 'line') {
						$url = C('ROOT_DOMAIN') . U('Line/pay?out_trade_no=' . $orderInfo['out_trade_no']);
					} else
						exit('error');
				}
				redirect($url);
				exit;

			}

		}

		$goods_str = '0';

		$goods_arr = S($goods_cache);
		$total_fee = 0;
		foreach ($goods_arr as $k => $v) {
			$total_fee += $v['amount'];
			$goods_str .= ',' . $v['id'];
		}
		$obj_mem = new MemberModel();
		$memInfo = $obj_mem->getInfoByUnionid($this->unionid, $this->source);


		$macInfo = M('Machine')->find($mac_id);
		if (!$macInfo) {
			$this->error(L('get_machine_info_fail'), '', true);
		}

		$coupon = D('MemberCoupon');
		$couponList = $coupon->getAvlList($macInfo['mid'], $memInfo['id'], $total_fee, $goods_str);

		if (IS_POST) {
//
//			$pre_url
//			session('pre_url', U('Index/confirm'));
//			//die('submit');
//			$url = U('Index/bind');
//			$this->success(L('place_order_succ'), $url, true);
//			exit;

			$balance = I('balance', 0);
			$credits = I('credits', 0);
			$coupon_id = I('coupon', 0);

			$data['out_trade_no'] = $out_trade_no ? $out_trade_no : make_orderSn($memInfo['id']);
			$data['mac_id'] = $mac_id;
			$data['fac_id'] = $macInfo['fac_id'];
			$data['agent_id'] = $macInfo['agent_id'];
			$data['mid'] = $macInfo['mid'];
			$data['userid'] = $memInfo['id'];
			$data['goods'] = $goods_arr;
			$data['total_fee'] = $total_fee;
			$data['balance'] = $balance;
			$data['credits'] = $credits;
			$data['coupon_id'] = $coupon_id;
			$data['mobile'] = $memInfo['mobile'];
			$data['note'] = I('note', '');
			$data['source'] = $from_machine == 1 ? 'machine' : $this->source;
			$data['yuyue'] = $from_machine == 1 ? 0 : 1; //柜机过来的订单，不属于预约订单

//			file_put_contents(dirname(__FILE__) . '/order.json', C('ROOT_DOMAIN'));
//			exit;
			$obj_order = D('order');
			$res = $obj_order->createOrder($data);
			if ($res) {
				$out_trade_no = $res['out_trade_no'];
				if ($res['pay_fee'] == 0) {//无需支付
					update_pay_success($out_trade_no, 'other_' . $out_trade_no); // 修改订单支付状态
					update_pay_type($out_trade_no, 'other');
					getAvlBox($out_trade_no, 'member'); //分配格子
					//check_baocang($out_trade_no);
					$url = U('Index/order_yuyue');

				} else {
					if ($this->source == 'weixin')
						$url = U('pay?out_trade_no=' . $res['out_trade_no']);
					elseif ($this->source == 'alipay')
						$url = U('pay_alipay?out_trade_no=' . $res['out_trade_no']);
					elseif ($this->source == 'line') {
						$url = C('ROOT_DOMAIN') . U('Line/pay?out_trade_no=' . $res['out_trade_no']);
					} else
						$url = C('ROOT_DOMAIN') . U('Line/pay?out_trade_no=' . $res['out_trade_no']);

					//exit('error');
				}
				$this->success(L('place_order_succ'), $url, true);

			} else {
				$this->error($obj_order->getError(), '', true);
			}

		} else {
			$this->assign('out_trade_no', $out_trade_no);
			$this->assign('couponList', $couponList);
			$this->assign('goods_arr', $goods_arr);
			$this->assign('total_fee', $total_fee);
			$this->assign('credits', $memInfo['credits']);
			$this->assign('amount', $memInfo['amount']);
			$this->meta_title = L('confirm_order');
			$this->display();
		}
	}


	//柜机超时订单，支付超时费
	public function pay_machine()
	{
		$out_trade_no = I('out_trade_no', '');
		if (!$out_trade_no) exit('error');
		$orderInfo = M('OrderCode')->where(array('out_trade_no' => $out_trade_no))->find();
		if (!$orderInfo) exit('error');
		if ($this->source == 'weixin')
			$url = U('pay?out_trade_no=' . $orderInfo['out_trade_no']);
		elseif ($this->source == 'alipay')
			$url = U('pay_alipay?out_trade_no=' . $orderInfo['out_trade_no']);
		elseif ($this->source == 'line') {
			$url = C('ROOT_DOMAIN') . U('Line/pay?out_trade_no=' . $orderInfo['out_trade_no']);
		} else
			exit('error');

		redirect($url);
		exit;
	}


	//支付页面--微信
	public function pay($out_trade_no)
	{

		if (substr($out_trade_no, 0, 1) == 'f') {
			$obj_order = M('OrderCode');
		} else {
			$obj_order = M('Order');
		}

		$orderInfo = $obj_order->where(array('out_trade_no' => $out_trade_no))->find();


		//     	print_pre($orderInfo);
		//     	exit;

		require_once VENDOR_PATH . 'Wxpay/lib/WxPay.Api.php';
		require_once VENDOR_PATH . 'Wxpay/example/WxPay.JsApiPay.php';

		//①、获取用户openid
		$tools = new \JsApiPay();
		$openId = $this->unionid;

		//②、统一下单
		$input = new \WxPayUnifiedOrder();
		$input->SetBody("kinglaundry wash service");
		$input->SetAttach("yichao");
		$input->SetOut_trade_no($orderInfo['out_trade_no']);
		if (C('is_develop') == 0) //非测试，使用正常价格
			$input->SetTotal_fee($orderInfo['pay_fee'] * 100);
		else
			$input->SetTotal_fee("1");
		$input->SetTime_start(date("YmdHis"));
		$input->SetTime_expire(date("YmdHis", time() + 600));
		$input->SetGoods_tag("test");
		$input->SetNotify_url(\WxPayConfig::NOTIFY_URL);
		$input->SetTrade_type("JSAPI");
		$input->SetOpenid($openId);
		$order = \WxPayApi::unifiedOrder($input);
		//     	echo '<font color="#f00"><b>统一下单支付单信息</b></font><br/>';
		//     	print_pre($order);
		$jsApiParameters = $tools->GetJsApiParameters($order);

		$this->assign('jsApiParameters', $jsApiParameters);
		$this->assign('orderInfo', $orderInfo);


		$this->display();
	}


	//支付页面--支付宝
	public function pay_alipay($out_trade_no)
	{

		if (substr($out_trade_no, 0, 1) == 'f') {
			$obj_order = M('OrderCode');
		} else {
			$obj_order = M('Order');
		}

		$orderInfo = $obj_order->where(array('out_trade_no' => $out_trade_no))->find();


		require_once VENDOR_PATH . 'Alipay/wappay/service/AlipayTradeService.php';
		require_once VENDOR_PATH . 'Alipay/wappay/buildermodel/AlipayTradeWapPayContentBuilder.php';
		require_once VENDOR_PATH . 'Alipay/config.php';

		//商户订单号，商户网站订单系统中唯一订单号，必填
		$out_trade_no = $orderInfo['out_trade_no'];
		//订单名称，必填
		$subject = "kinglaundry wash service";
		//付款金额，必填
		$total_amount = $orderInfo['pay_fee'];
		//商品描述，可空
		$body = "";
		//超时时间
		$timeout_express = "1m";

		$payRequestBuilder = new \AlipayTradeWapPayContentBuilder();
		$payRequestBuilder->setBody($body);
		$payRequestBuilder->setSubject($subject);
		$payRequestBuilder->setOutTradeNo($out_trade_no);
		$payRequestBuilder->setTotalAmount($total_amount);
		$payRequestBuilder->setTimeExpress($timeout_express);

		if ($orderInfo['yuyue'] == 1)
			$config['return_url'] = C('ROOT_DOMAIN') . "/Home/Index/order_yuyue";
		else
			$config['return_url'] = C('ROOT_DOMAIN') . "/Home/Index/order";
		$config['notify_url'] = C('ROOT_DOMAIN') . "/Home/Pay/alipayNotify";

		$payResponse = new \AlipayTradeService($config);
		$result = $payResponse->wapPay($payRequestBuilder, $config['return_url'], $config['notify_url']);

		return;

	}


	//绑定手机页面
	public function bind($type = 'bind')
	{

		$pre_url = session('pre_url');

		if (IS_POST) {
			$mobile = I('mobile', '');
			$vcode = I('vcode', '');

			//短信验证todo
			$obj_vcode = new Vcode();
			$res = $obj_vcode->check_vcode($mobile, $vcode);
			if (!$res) {
				$this->error($obj_vcode->error, '', true);
			}

			$obj_mem = new MemberModel();
			$memInfo = $obj_mem->getInfoByUnionid($this->unionid, $this->source);
			if ($memInfo) {//修改手机号
				$type = 'modify';
				$tmpInfo = $obj_mem->getInfoByMobile($mobile);
				if ($tmpInfo) {
					$this->error(L('mobile_has_bind'), '', true);
				}
				$data['id'] = $memInfo['id'];
				$data['mobile'] = $mobile;
				$obj_mem->save($data);
			} else {//绑定手机号
				$type = 'bind';
				$tmpInfo = $obj_mem->getInfoByMobile($mobile);
				if (!$tmpInfo) {//柜机未注册
					$obj_mem->regByUnionid($this->unionid, $mobile, $this->source);
				} elseif (!$tmpInfo['alipayid'] && $this->source == 'alipay') {//柜机已注册，但未绑定支付宝
					$data['id'] = $tmpInfo['id'];
					$data['alipayid'] = $this->unionid;
					$obj_mem->save($data);
				} elseif (!$tmpInfo['openid'] && $this->source == 'weixin') {//柜机已注册，但未绑定微信
					$data['id'] = $tmpInfo['id'];
					$data['openid'] = $this->unionid;
					$obj_mem->save($data);
				} else {
					$this->error(L('mobile_has_bind'), '', true);
				}

				//活动，新用户送券
				//再次获取用户信息，活动日期内注册的用户，给予代金券

				/////////////////////
			}

			$msg = $type == 'bind' ? L('bind_succ') : L('modify_succ');
			$this->success(L('set_succ'), $pre_url, true);

		} else {
			$token = md5('sendVcode' . AUTH_KEY . date('Ymd'));
			$url = C('ROOT_DOMAIN') . U('sendVcode?mobile=15012345678&yctoken=' . $token);
			$title = $type == 'bind' ? L('bind_first') : L('enter_new_phone');
			$this->assign('url', $url);
			$this->assign('title', $title);
			$this->meta_title = L('set_mobile');
			$this->display();
		}

	}


	//发送验证码
	public function sendVcode()
	{
//         echo 1;exit;
		$result = array('status' => 0, 'info' => '');

		$mobile = I('mobile', '');
		$check = Check::isMobile($mobile);
		if (!$check) {
			$this->error(L('mobile_error'), '', true);
		}

		$token = I('yctoken', '');
		$local_token = md5('sendVcode' . AUTH_KEY . date('Ymd'));
		if ($token != $local_token)
			$this->error('验证失败', '', true);

		$obj_vcode = new Vcode();
		$vcode = $obj_vcode->set_vcode($mobile);
		if ($vcode == false) {
			$this->error($obj_vcode->error, '', true);
		}

		$params['code'] = $vcode;
		//     	$this->success($vcode,'',true);
		$obj_sms = new Sms();
		$status = $obj_sms->send($mobile, 'verify_code', $params);
		if (!$status) {
			$this->error($obj_sms->error, '', true);
		} else {
			$this->success(L('sms_ok'), '', true);
		}

	}


	//预约订单列表
	public function order_yuyue()
	{
		$this->meta_title = L('my_reservation');

		$obj_mem = new MemberModel();
		$memInfo = $obj_mem->getInfoById($this->userid);
		if (!$memInfo) {
			$this->display('order_no');
			exit;
		}
		$map = array(
			'yuyue'      => 1,
			'pay_status' => 1,
			'is_fault'   => 0,
			'userid'     => $memInfo['id'],
		);
		$list = $this->getAllRows('order', true, $map);

		if (empty($list)) {
			$this->display('order_no');
			exit;
		}
		$this->assign('list', $list);

		$this->display();
	}


	//订单列表
	public function order()
	{
		$this->meta_title = L('my_order');

		$obj_mem = new MemberModel();
		$memInfo = $obj_mem->getInfoById($this->userid);
		if (!$memInfo) {
			$this->display('order_no');
			exit;
		}
		$map = array(
			'yuyue'      => 0,
			'pay_status' => 1,
			'is_fault'   => 0,
			'userid'     => $memInfo['id'],
		);
		$list = $this->getAllRows('order', true, $map);
		if (empty($list)) {
			$this->display('order_no');
			exit;
		}

		$this->assign('list', $list);


		$this->display();
	}


	//订单详情
	public function order_detail($id)
	{
		$orderInfo = M('order')->find($id);
		if ($orderInfo['status'] == 3) {
			$orderCode = M('OrderCode')->where(array('order_sn' => $orderInfo['out_trade_no']))->find();
			$orderInfo['code'] = $orderCode['code'];
		}

		$this->assign('orderInfo', $orderInfo);

		$this->meta_title = L('order_details');
		$this->display();
	}


	//更多服务
	public function more_service()
	{
		$this->meta_title = '更多服务';
		$this->display();
	}


	//生成充值订单
	public function charge()
	{

		if (IS_POST) {
			$money = I('money', 0);
			if (!$money) {
				$this->error(L('recharge_amount_error'), '', true);
			}

			$memObj = new MemberModel();
			$memInfo = $memObj->getInfoById($this->userid);
			$uid = $memInfo['id'];

			$order['out_trade_no'] = 'c' . $uid . time() . rand(10000, 99999);
			$order['userid'] = $uid;
			$order['pay_fee'] = $money;
			$order['createtime'] = time();
			$order['source'] = 'weixin';

			M('OrderCharge')->add($order);

			if ($this->source == 'weixin')
				$this->success(L('to_pay'), U('do_charge?out_trade_no=' . $order['out_trade_no']), true);
			elseif ($this->source == 'alipay')
				$this->success(L('to_pay'), U('do_charge_alipay?out_trade_no=' . $order['out_trade_no']), true);
			elseif ($this->source == 'line') {
				$url = C('ROOT_DOMAIN') . U('Line/do_charge?out_trade_no=' . $order['out_trade_no']);
				$this->success(L('to_pay'), $url, true);
			} else
				exit('error');
		} else {
			$map['status'] = 1;
			$rules = $this->lists('ChargeRule', $map, 'sort desc');
			$this->assign('rules', $rules);
			$this->meta_title = L('online_recharge');
			$this->display();
		}

	}


	//充值支付页面--微信
	public function do_charge($out_trade_no)
	{
		$obj_order = M('OrderCharge');
		$map = array('out_trade_no' => $out_trade_no);
		$orderInfo = $obj_order->where($map)->find();

		//     	print_pre($orderInfo);
		//     	exit;

		require_once VENDOR_PATH . 'Wxpay/lib/WxPay.Api.php';
		require_once VENDOR_PATH . 'Wxpay/example/WxPay.JsApiPay.php';

		//①、获取用户openid
		$tools = new \JsApiPay();
		$openId = $this->unionid;

		//②、统一下单
		$input = new \WxPayUnifiedOrder();
		$input->SetBody("Online recharge");
		$input->SetAttach("yichao");
		$input->SetOut_trade_no($orderInfo['out_trade_no']);
		$input->SetTotal_fee($orderInfo['pay_fee'] * 100);
//         $input->SetTotal_fee("1");
		$input->SetTime_start(date("YmdHis"));
		$input->SetTime_expire(date("YmdHis", time() + 600));
		$input->SetGoods_tag("test");
		$input->SetNotify_url(\WxPayConfig::NOTIFY_URL);
		$input->SetTrade_type("JSAPI");
		$input->SetOpenid($openId);
		$order = \WxPayApi::unifiedOrder($input);
		//     	echo '<font color="#f00"><b>统一下单支付单信息</b></font><br/>';
		//     	print_pre($order);
		$jsApiParameters = $tools->GetJsApiParameters($order);

		$this->assign('jsApiParameters', $jsApiParameters);
		$this->assign('orderInfo', $orderInfo);


		$this->display();
	}


	//充值支付页面--支付宝
	public function do_charge_alipay($out_trade_no)
	{
		$obj_order = M('OrderCharge');
		$map = array('out_trade_no' => $out_trade_no);
		$orderInfo = $obj_order->where($map)->find();


		require_once VENDOR_PATH . 'Alipay/wappay/service/AlipayTradeService.php';
		require_once VENDOR_PATH . 'Alipay/wappay/buildermodel/AlipayTradeWapPayContentBuilder.php';
		require_once VENDOR_PATH . 'Alipay/config.php';

		//商户订单号，商户网站订单系统中唯一订单号，必填
		$out_trade_no = $orderInfo['out_trade_no'];
		//订单名称，必填
		$subject = "Online recharge";
		//付款金额，必填
		$total_amount = $orderInfo['pay_fee'];
		//商品描述，可空
		$body = "";
		//超时时间
		$timeout_express = "1m";

		$config['return_url'] = C('ROOT_DOMAIN') . "/Home/User/index";
		$config['notify_url'] = C('ROOT_DOMAIN') . "/Home/Pay/alipayNotify";

		$payRequestBuilder = new \AlipayTradeWapPayContentBuilder();
		$payRequestBuilder->setBody($body);
		$payRequestBuilder->setSubject($subject);
		$payRequestBuilder->setOutTradeNo($out_trade_no);
		$payRequestBuilder->setTotalAmount($total_amount);
		$payRequestBuilder->setTimeExpress($timeout_express);

		$payResponse = new \AlipayTradeService($config);
		$result = $payResponse->wapPay($payRequestBuilder, $config['return_url'], $config['notify_url']);

		return;

	}


	//微信、支付宝扫描柜机二维码登录
	public function scanLogin($ukey = '', $token = '')
	{
		$local_token = md5('scanLogin' . AUTH_KEY . date('Ymd'));
		if ($token != $local_token) {
			exit('error');
		}

		$pre_url = U('scanLogin?ukey=' . $ukey . '&token=' . $token);
		session('pre_url', $pre_url);

		$obj_mem = new MemberModel();
		$memInfo = $obj_mem->getInfoById($this->userid);
		if (!$memInfo || !$memInfo['mobile']) {//未绑定手机号，去绑定
			redirect(U('bind'));
			exit;
		}

//         print_pre($memInfo);

		if (IS_AJAX) {
			setScanLogin($ukey, $memInfo);
			$this->success(L('login_succ'), '', true);

		} else {
			$this->assign('pre_url', $pre_url);
			$this->assign('ukey', $ukey);
			$this->meta_title = L('confirm_login');
			$this->display();
		}

	}


	//微信、支付宝扫描柜机二维码取件
	public function scanFetch($ukey = '', $mac_id = 0, $token = '')
	{
		$local_token = md5('scanFetch' . AUTH_KEY . date('Ymd'));
//         if($token!=$local_token){
//             exit('error');
//         }

		$pre_url = U('scanFetch?ukey=' . $ukey . '&mac_id=' . $mac_id . '&token=' . $token);
		session('pre_url', $pre_url);

		$obj_mem = new MemberModel();
		$memInfo = $obj_mem->getInfoById($this->userid);
		if (!$memInfo || !$memInfo['mobile']) {//未绑定手机号，去绑定
			redirect(U('bind'));
			exit;
		}

		//         print_pre($memInfo);

		if (IS_AJAX) {
			$map['userid'] = $memInfo['id'];
			$map['status'] = 0;
			$map['mac_id'] = $mac_id;
			$list = M('OrderCode')->where($map)->select();

			if (empty($list)) {
				$this->error(L('no_clothes_fetch'), '', true);
			}

			$now = time();
			$code_arr = array();
			foreach ($list as $v) {
//                 $times = $now - $v['createtime'];
//                 if($times>3600*24){
//                     $this->error('存在超期订单，请在柜机处理','',true);
//                 }
				$code_arr[] = $v['code'];

			}

			setScanFetch($ukey, $code_arr);
			$this->success(L('picking_up'), '', true);

		} else {
			$this->assign('pre_url', $pre_url);
			$this->assign('ukey', $ukey);
			$this->meta_title = L('confirm_pick_up');
			$this->display();
		}

	}


	public function paySucc()
	{
		$this->meta_title = L('pay_result');
		$this->display();
	}


}
