<?php

namespace Merchant\Controller;

/*
 * 柜机
 */
class MachineController extends AdminController {

    /**
     * 列表
     */
    public function index(){
        $keywords       =   I('keywords');
        $map['status'] = 1;
        $map['mid'] = UID;
        if(!empty($keywords)){
            $map['title|serial_no|address']    =   array('like', '%'.(string)$keywords.'%');
        }

        $list   = $this->lists(CONTROLLER_NAME, $map);
        int_to_string($list);
        $this->assign('_list', $list);
        $this->assign('keywords', $keywords);
        $this->meta_title = 'Machine List';
        $this->display('index');
    }
    
    
    
    /*
     * 编辑柜机
     */
    public function edit(){
        if(IS_POST){
            $this->save(CONTROLLER_NAME,'index');
    
        } else {
            $info = $this->getInfo(CONTROLLER_NAME);
    
            $this->assign('info',$info);
            $this->meta_title = '编辑柜机' ;
            $this->display();
        }
    }
    


    


    /**
     * 格子列表
     */
    public function box($mac_id=0){
    	$map['status'] = array('in','1,0,-1');
    	$map['mac_id'] = $mac_id;

    	$list   = $this->lists('MachineBox', $map);
    	int_to_string($list);
    	$this->assign('_list', $list);
    	$this->meta_title = 'Box List';
    	$this->display('box');
    }


}