<?php
namespace Merchant\Controller;
use Org\Mac;
use Org\Sms;
use Api\Model\OrderModel;

/**
 * 订单控制器
 */
class OrderController extends AdminController {


    /**
     * 列表页
     */
    public function index(){

        $keywords = I('keywords','');
        $mac_id = I('mac_id',0);
        $order_status = I('order_status','');

        $map['mid'] = UID;
        $map['is_fault'] = 0;

    	if(!empty($keywords)){
    		$map['out_trade_no|mobile'] = array('like', '%'.(string)$keywords.'%');
    	}
        if(!empty($mac_id)){
            $map['mac_id'] = $mac_id;
        }
        if(!empty($order_status)){
            switch ($order_status){
                case 'yuyue':
                    $map['status'] = 1;
                    $map['yuyue'] = 1;
                    $map['pay_status'] = 1;
                    break;
                case 'wait_admin_fetch':
                    $map['status'] = 1;
                    $map['yuyue'] = 0;
                    $map['pay_status'] = 1;
                    break;
                case 'no_pay':
                    $map['status'] = 1;
                    $map['pay_status'] = 0;
                    break;
                case 'admin_has_fetch':
                    $map['status'] = 2;
                    break;
                case 'wait_customer_fetch':
                    $map['status'] = 3;
                    break;
                case 'finish':
                    $map['status'] = 10;
                    break;
                default:
                    break;
            }
        }

        $list   = $this->lists(CONTROLLER_NAME, $map);
        $macList = $this->getAllRows('Machine',true,array('status'=>1,'mid'=>UID));

        $this->assign('keywords', $keywords);
        $this->assign('mac_id', $mac_id);
        $this->assign('order_status', $order_status);
        $this->assign('_list', $list);
        $this->assign('macList', $macList);
        $this->assign('orderStatus', C('OrderStatus'));
        $this->meta_title = 'Order list';
        $this->display();
    }



    /**
     * 浏览页面
     */
    public function view(){
    	$info = $this->getInfo('Order');
    	$goods = json_decode($info['body'],true);
    	$log = $this->getAllRows('OrderLog',true,array('out_trade_no'=>$info['out_trade_no']));

        $this->assign('info',$info);
        $this->assign('goods',$goods);
        $this->assign('log',$log);
        $this->meta_title = 'Order detial' ;
        $this->display();
    }


    /**
     * 编辑页面
     */
    public function edit(){
    	if(IS_POST){
    		$this->save(CONTROLLER_NAME,'',false);
    	}else {
    		$this->display();
    	}
    }


    /**
     * 完成订单，释放格子
     */
    public function finish($out_trade_no=''){
        
        $obj_order = new OrderModel();
        $res = $obj_order->finish($out_trade_no);

        if($res){
            $this->success('Operation succeeded');
        }else{
            $this->error('Operation failure');
        }
    }


    //打开箱门
    Public function openBox($id=0){

    	$orderInfo = $this->getInfo('Order');
    	if(!$orderInfo ){
    		$this->error('Failed to obtain order information');
    	}
    	if($orderInfo['status']==10 || $orderInfo['pay_status']==0 ){
    		$this->error('Order status is incorrect');
    	}
    	if(!$orderInfo['box']){
    		$this->error('parameter error');
    	}
    	
    	$macInfo = M('Machine')->find($orderInfo['mac_id']);
    	if(!$macInfo){
    	    $this->error('parameter error');
    	}

    	$box_arr = explode(',', $orderInfo['box']);
    	$mac = new Mac();

    	foreach ($box_arr as $b){
    		$res = $mac->openDoor($macInfo['serial_no'], $orderInfo['mac_id'],$b,$orderInfo['out_trade_no']);
    		$res = json_decode($res,true);
    		sleep(2);
    	}
    	if($res['success']){
    		$this->success('Operation succeeded');
    	}else{
    	    $this->error('Operation failure');
    	}
    }


    //打印条码
    Public function printBarcode($id=0){
    	$orderInfo = $this->getInfo('Order');

    	if(!$orderInfo ){
    		$this->error('Failed to obtain order information');
    	}
    	if($orderInfo['status']==10 || $orderInfo['pay_status']==0 ){
    		$this->error('Order status is incorrect');
    	}

    	$mac = new Mac();
    	$res = $mac->printBarcode($orderInfo);
    	$res = json_decode($res,true);
    	if($res['success']){
    		$this->success('Print success');
    	}else{
    		$this->error('Print failure');
    	}
    }
    
    
    //发送取件码
    Public function sendSms($id=0){
        $orderInfo = $this->getInfo('Order');
    
        if(!$orderInfo ){
            $this->error('Failed to obtain order information');
        }
        if($orderInfo['status']!=3 ){
            $this->error('Order status is incorrect');
        }
        $info = M('OrderCode')->where(array('order_sn'=>$orderInfo['out_trade_no']))->find();
        $code = $info['code'];
    
        $macInfo = M('Machine')->find($orderInfo['mac_id']);
    
        //发送短信，通知用户取件
        $params['code'] = $code;
        $params['address'] = $macInfo['address'];
        $obj_sms = new Sms();
        $status = $obj_sms->send($orderInfo['mobile'], 'finish_notify', $params);
    
        if($status){
            $this->success('SMS sent successfully');
        }else{
            $this->error('SMS sent failed');
        }
    }


}