<?php

/**
 * AttributesApi
 * PHP version 5
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
/**
 * SendinBlue API
 *
 * SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |
 *
 * OpenAPI spec version: 3.0.0
 * Contact: contact@sendinblue.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.12
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
namespace WPMailSMTP\Vendor\SendinBlue\Client\Api;

use WPMailSMTP\Vendor\GuzzleHttp\Client;
use WPMailSMTP\Vendor\GuzzleHttp\ClientInterface;
use WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream;
use WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request;
use WPMailSMTP\Vendor\GuzzleHttp\RequestOptions;
use WPMailSMTP\Vendor\SendinBlue\Client\ApiException;
use WPMailSMTP\Vendor\SendinBlue\Client\Configuration;
use WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector;
use WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer;
/**
 * AttributesApi Class Doc Comment
 *
 * @category Class
 * @package  SendinBlue\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AttributesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;
    /**
     * @var Configuration
     */
    protected $config;
    /**
     * @var HeaderSelector
     */
    protected $headerSelector;
    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(\WPMailSMTP\Vendor\GuzzleHttp\ClientInterface $client = null, \WPMailSMTP\Vendor\SendinBlue\Client\Configuration $config = null, \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector $selector = null)
    {
        $this->client = $client ?: new \WPMailSMTP\Vendor\GuzzleHttp\Client();
        $this->config = $config ?: new \WPMailSMTP\Vendor\SendinBlue\Client\Configuration();
        $this->headerSelector = $selector ?: new \WPMailSMTP\Vendor\SendinBlue\Client\HeaderSelector();
    }
    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }
    /**
     * Operation createAttribute
     *
     * Create contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the attribute (required)
     * @param  \SendinBlue\Client\Model\CreateAttribute $createAttribute Values to create an attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function createAttribute($attributeCategory, $attributeName, $createAttribute)
    {
        $this->createAttributeWithHttpInfo($attributeCategory, $attributeName, $createAttribute);
    }
    /**
     * Operation createAttributeWithHttpInfo
     *
     * Create contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the attribute (required)
     * @param  \SendinBlue\Client\Model\CreateAttribute $createAttribute Values to create an attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAttributeWithHttpInfo($attributeCategory, $attributeName, $createAttribute)
    {
        $returnType = '';
        $request = $this->createAttributeRequest($attributeCategory, $attributeName, $createAttribute);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createAttributeAsync
     *
     * Create contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the attribute (required)
     * @param  \SendinBlue\Client\Model\CreateAttribute $createAttribute Values to create an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAttributeAsync($attributeCategory, $attributeName, $createAttribute)
    {
        return $this->createAttributeAsyncWithHttpInfo($attributeCategory, $attributeName, $createAttribute)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation createAttributeAsyncWithHttpInfo
     *
     * Create contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the attribute (required)
     * @param  \SendinBlue\Client\Model\CreateAttribute $createAttribute Values to create an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAttributeAsyncWithHttpInfo($attributeCategory, $attributeName, $createAttribute)
    {
        $returnType = '';
        $request = $this->createAttributeRequest($attributeCategory, $attributeName, $createAttribute);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'createAttribute'
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the attribute (required)
     * @param  \SendinBlue\Client\Model\CreateAttribute $createAttribute Values to create an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function createAttributeRequest($attributeCategory, $attributeName, $createAttribute)
    {
        // verify the required parameter 'attributeCategory' is set
        if ($attributeCategory === null || \is_array($attributeCategory) && \count($attributeCategory) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeCategory when calling createAttribute');
        }
        // verify the required parameter 'attributeName' is set
        if ($attributeName === null || \is_array($attributeName) && \count($attributeName) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeName when calling createAttribute');
        }
        // verify the required parameter 'createAttribute' is set
        if ($createAttribute === null || \is_array($createAttribute) && \count($createAttribute) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $createAttribute when calling createAttribute');
        }
        $resourcePath = '/contacts/attributes/{attributeCategory}/{attributeName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($attributeCategory !== null) {
            $resourcePath = \str_replace('{' . 'attributeCategory' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeCategory), $resourcePath);
        }
        // path params
        if ($attributeName !== null) {
            $resourcePath = \str_replace('{' . 'attributeName' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeName), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($createAttribute)) {
            $_tempBody = $createAttribute;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('POST', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation deleteAttribute
     *
     * Delete an attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteAttribute($attributeCategory, $attributeName)
    {
        $this->deleteAttributeWithHttpInfo($attributeCategory, $attributeName);
    }
    /**
     * Operation deleteAttributeWithHttpInfo
     *
     * Delete an attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAttributeWithHttpInfo($attributeCategory, $attributeName)
    {
        $returnType = '';
        $request = $this->deleteAttributeRequest($attributeCategory, $attributeName);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteAttributeAsync
     *
     * Delete an attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAttributeAsync($attributeCategory, $attributeName)
    {
        return $this->deleteAttributeAsyncWithHttpInfo($attributeCategory, $attributeName)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation deleteAttributeAsyncWithHttpInfo
     *
     * Delete an attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAttributeAsyncWithHttpInfo($attributeCategory, $attributeName)
    {
        $returnType = '';
        $request = $this->deleteAttributeRequest($attributeCategory, $attributeName);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'deleteAttribute'
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function deleteAttributeRequest($attributeCategory, $attributeName)
    {
        // verify the required parameter 'attributeCategory' is set
        if ($attributeCategory === null || \is_array($attributeCategory) && \count($attributeCategory) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeCategory when calling deleteAttribute');
        }
        // verify the required parameter 'attributeName' is set
        if ($attributeName === null || \is_array($attributeName) && \count($attributeName) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeName when calling deleteAttribute');
        }
        $resourcePath = '/contacts/attributes/{attributeCategory}/{attributeName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($attributeCategory !== null) {
            $resourcePath = \str_replace('{' . 'attributeCategory' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeCategory), $resourcePath);
        }
        // path params
        if ($attributeName !== null) {
            $resourcePath = \str_replace('{' . 'attributeName' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeName), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('DELETE', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation getAttributes
     *
     * List all attributes
     *
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \SendinBlue\Client\Model\GetAttributes
     */
    public function getAttributes()
    {
        list($response) = $this->getAttributesWithHttpInfo();
        return $response;
    }
    /**
     * Operation getAttributesWithHttpInfo
     *
     * List all attributes
     *
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \SendinBlue\Client\Model\GetAttributes, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttributesWithHttpInfo()
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetAttributes';
        $request = $this->getAttributesRequest();
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetAttributes', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getAttributesAsync
     *
     * List all attributes
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAttributesAsync()
    {
        return $this->getAttributesAsyncWithHttpInfo()->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation getAttributesAsyncWithHttpInfo
     *
     * List all attributes
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAttributesAsyncWithHttpInfo()
    {
        $returnType = 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\GetAttributes';
        $request = $this->getAttributesRequest();
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            $responseBody = $response->getBody();
            if ($returnType === '\\SplFileObject') {
                $content = $responseBody;
                //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if ($returnType !== 'string') {
                    $content = \json_decode($content);
                }
            }
            return [\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($content, $returnType, []), $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'getAttributes'
     *
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getAttributesRequest()
    {
        $resourcePath = '/contacts/attributes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('GET', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Operation updateAttribute
     *
     * Update contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     * @param  \SendinBlue\Client\Model\UpdateAttribute $updateAttribute Values to update an attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function updateAttribute($attributeCategory, $attributeName, $updateAttribute)
    {
        $this->updateAttributeWithHttpInfo($attributeCategory, $attributeName, $updateAttribute);
    }
    /**
     * Operation updateAttributeWithHttpInfo
     *
     * Update contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     * @param  \SendinBlue\Client\Model\UpdateAttribute $updateAttribute Values to update an attribute (required)
     *
     * @throws \SendinBlue\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAttributeWithHttpInfo($attributeCategory, $attributeName, $updateAttribute)
    {
        $returnType = '';
        $request = $this->updateAttributeRequest($attributeCategory, $attributeName, $updateAttribute);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (\WPMailSMTP\Vendor\GuzzleHttp\Exception\RequestException $e) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException("[{$e->getCode()}] {$e->getMessage()}", $e->getCode(), $e->getResponse() ? $e->getResponse()->getHeaders() : null, $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null);
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $request->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (\WPMailSMTP\Vendor\SendinBlue\Client\ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::deserialize($e->getResponseBody(), 'WPMailSMTP\\Vendor\\SendinBlue\\Client\\Model\\ErrorModel', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateAttributeAsync
     *
     * Update contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     * @param  \SendinBlue\Client\Model\UpdateAttribute $updateAttribute Values to update an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAttributeAsync($attributeCategory, $attributeName, $updateAttribute)
    {
        return $this->updateAttributeAsyncWithHttpInfo($attributeCategory, $attributeName, $updateAttribute)->then(function ($response) {
            return $response[0];
        });
    }
    /**
     * Operation updateAttributeAsyncWithHttpInfo
     *
     * Update contact attribute
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     * @param  \SendinBlue\Client\Model\UpdateAttribute $updateAttribute Values to update an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAttributeAsyncWithHttpInfo($attributeCategory, $attributeName, $updateAttribute)
    {
        $returnType = '';
        $request = $this->updateAttributeRequest($attributeCategory, $attributeName, $updateAttribute);
        return $this->client->sendAsync($request, $this->createHttpClientOption())->then(function ($response) use($returnType) {
            return [null, $response->getStatusCode(), $response->getHeaders()];
        }, function ($exception) {
            $response = $exception->getResponse();
            $statusCode = $response->getStatusCode();
            throw new \WPMailSMTP\Vendor\SendinBlue\Client\ApiException(\sprintf('[%d] Error connecting to the API (%s)', $statusCode, $exception->getRequest()->getUri()), $statusCode, $response->getHeaders(), $response->getBody());
        });
    }
    /**
     * Create request for operation 'updateAttribute'
     *
     * @param  string $attributeCategory Category of the attribute (required)
     * @param  string $attributeName Name of the existing attribute (required)
     * @param  \SendinBlue\Client\Model\UpdateAttribute $updateAttribute Values to update an attribute (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function updateAttributeRequest($attributeCategory, $attributeName, $updateAttribute)
    {
        // verify the required parameter 'attributeCategory' is set
        if ($attributeCategory === null || \is_array($attributeCategory) && \count($attributeCategory) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeCategory when calling updateAttribute');
        }
        // verify the required parameter 'attributeName' is set
        if ($attributeName === null || \is_array($attributeName) && \count($attributeName) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $attributeName when calling updateAttribute');
        }
        // verify the required parameter 'updateAttribute' is set
        if ($updateAttribute === null || \is_array($updateAttribute) && \count($updateAttribute) === 0) {
            throw new \InvalidArgumentException('Missing the required parameter $updateAttribute when calling updateAttribute');
        }
        $resourcePath = '/contacts/attributes/{attributeCategory}/{attributeName}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = \false;
        // path params
        if ($attributeCategory !== null) {
            $resourcePath = \str_replace('{' . 'attributeCategory' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeCategory), $resourcePath);
        }
        // path params
        if ($attributeName !== null) {
            $resourcePath = \str_replace('{' . 'attributeName' . '}', \WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::toPathValue($attributeName), $resourcePath);
        }
        // body params
        $_tempBody = null;
        if (isset($updateAttribute)) {
            $_tempBody = $updateAttribute;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(['application/json']);
        } else {
            $headers = $this->headerSelector->selectHeaders(['application/json'], ['application/json']);
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            if ($headers['Content-Type'] === 'application/json') {
                // \stdClass has no __toString(), so we should encode it manually
                if ($httpBody instanceof \stdClass) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($httpBody);
                }
                // array has no __toString(), so we should encode it manually
                if (\is_array($httpBody)) {
                    $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode(\WPMailSMTP\Vendor\SendinBlue\Client\ObjectSerializer::sanitizeForSerialization($httpBody));
                }
            }
        } elseif (\count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = ['name' => $formParamName, 'contents' => $formParamValue];
                }
                // for HTTP post (form)
                $httpBody = new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\MultipartStream($multipartContents);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('api-key');
        if ($apiKey !== null) {
            $headers['api-key'] = $apiKey;
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('partner-key');
        if ($apiKey !== null) {
            $headers['partner-key'] = $apiKey;
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = \array_merge($defaultHeaders, $headerParams, $headers);
        $query = \WPMailSMTP\Vendor\GuzzleHttp\Psr7\build_query($queryParams);
        return new \WPMailSMTP\Vendor\GuzzleHttp\Psr7\Request('PUT', $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''), $headers, $httpBody);
    }
    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG] = \fopen($this->config->getDebugFile(), 'a');
            if (!$options[\WPMailSMTP\Vendor\GuzzleHttp\RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }
        return $options;
    }
}
