<?php
/*
 * Template Name: Contact
 */

get_header();
the_post();
$data = get_fields();
?>

<div class="block-section">
    <div class="container">
        <div class="text-center">
            <h1 class="mb-4"><?php the_title(); ?></h1>
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <div class="card border-0 shadow overflow-hidden w-100">
                        <div class="img-view xl">
                            <div class="img-placeholder">
                                <div class="img-show" style="background-image:url('<?php asset('images/map.png') ?>');background-size:180%;"></div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-4 mb-md-0">
                                <div class="contact-fsbox p-lg-4 p-3 mb-4 bg-secondary text-center">
                                    <div class="h3 text-white">โปรดเลือกสถานที่</div>
                                    <div class="px-lg-5 pb-4">
                                        <select name="place" class="form-control">
                                            <?php foreach ($data['branchs'] as $k => $item) : ?>
                                                <option value="<?= $k; ?>"><?= $item['name']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="row justify-content-center">
                                    <div class="col-lg-8">
                                        <div class="row align-items-center mb-4">
                                            <div class="col-4 text-center text-seconary h1">S</div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">20</div>
                                                <div><small>Baht/Hrs.</small></div>
                                            </div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">120</div>
                                                <div><small>Baht/Day</small></div>
                                            </div>
                                        </div>
                                        <div class="row align-items-center mb-4">
                                            <div class="col-4 text-center text-seconary h1">M</div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">30</div>
                                                <div><small>Baht/Hrs.</small></div>
                                            </div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">180</div>
                                                <div><small>Baht/Day</small></div>
                                            </div>
                                        </div>
                                        <div class="row align-items-center mb-4">
                                            <div class="col-4 text-center text-seconary h1">L</div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">40</div>
                                                <div><small>Baht/Hrs.</small></div>
                                            </div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">140</div>
                                                <div><small>Baht/Day</small></div>
                                            </div>
                                        </div>
                                        <div class="row align-items-center mb-4">
                                            <div class="col-4 text-center text-seconary h1">E</div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">60</div>
                                                <div><small>Baht/Hrs.</small></div>
                                            </div>
                                            <div class="col-4 text-center text-primary">
                                                <div class="h1 lh0 mb-0">180</div>
                                                <div><small>Baht/Day</small></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <?php foreach ($data['branchs'] as $k => $item) : ?>
                                    <div id="b-<?= $k; ?>" class="pr-md-4 pt-4 place-view <?= ($k) ? 'd-none' : '' ?>">
                                        <div class="image text-center mb-3">
                                            <img src="<?= $item['image_view']['url']; ?>" class="w-100">
                                        </div>
                                        <div class="text-left px-4 px-md-0 mb-4 mb-md-0">
                                            <div class="h2 mb-0 text-primary "><?= $item['name']; ?></div>
                                            <div class="text-muted mb-4 h4"><?= $item['open_date']; ?></div>
                                            <a target="_blank" href="<?php echo $item['google_map']; ?>" class="text-danger">Click to Google Maps</a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>
    </div>
</div>


<?php get_footer();
