<?php
/*
 * Template Name: Home
 */

get_header();
$data = get_fields();
?>
<div class="slider slider-image py-lg-4">
    <div class="container">
        <div class="row no-gutters align-items-center">
            <div class="col-lg-7">
                <h1 class="text-uppercase h1x mb-0"><span class="text-seconary">Easy</span> Wash 24</h1>
                <div class="h1 text-uppercase mb-lg-5 mb-3">Laundry & Dry Clean</div>
                <div class="h1 text-uppercase mb-1 font-weight-bold">ให้บริการซักอบรีด</div>
                <div class="h2 text-uppercase mb-lg-5 font-weight-light mb-3">ผ่านช่องทางตู้ รับ-ส่ง-ฝาก <br>อัตโนมัติ 24 ชม.</div>
                <div class="d-md-none">
                    <img src="<?php asset('images/standing.png'); ?>" class="w-100">
                </div>
                <div class="d-flex flex-wrap">
                    <a href="/contact" class="btn btn-primary btn-lg w-100 w-lg-auto px-5 mb-3 mr-lg-3">ติดต่อเรา</a>
                    <a href="<?= $data['find_locker_link']; ?>" class="btn btn-outline-primary btn-lg w-100 w-lg-auto mb-3 px-5">ค้นหาล็อกเกอร์ใกล้คุณ</a>
                </div>
            </div>
            <div class="col-lg-5 d-none d-lg-block">
                <div>
                    <img src="<?php asset('images/standing.png'); ?>" class="w-100">
                </div>
            </div>
        </div>
    </div>
</div>

<div class="block-section block-section-xl bg-circle pb-0">
    <div class="container">
        <div class="row no-gutters">
            <div class="col-lg-5 d-none d-lg-block">
                <div class="text-center -indent-right position-relative" style="z-index: 100;">
                    <img src="<?php asset('images/girl-wash.png'); ?>" class="w-100">
                </div>
            </div>
            <div class="col-lg-7">
                <div class="">
                    <h2 class="h1 mb-3 text-center">
                        บริการ<span class="text-seconary">ซักอบรีด</span>
                    </h2>
                    <div class="card border-0 bg-gray mb-4">
                        <div class="card-body font-weight-light px-lg-4 py-lg-4">
                            <div class="ml-lg-3">
                                <?php echo wpautop($data['welcome_content'], true) ?>
                            </div>
                        </div>
                    </div>
                    <div class="h2 mb-3 text-center">
                        "สนใจซักผ้า <span class="text-seconary">คลิก</span>"
                    </div>
                    <div class="text-center">
                        <a href="<?= $data['wash_link']; ?>" class="btn btn-seconary btn-lg px-5 mb-3 mr-3">ซักเลย</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="block-section block-section-xl pb-0">
    <div class="container">
        <h2 class="h1 mb-3 text-center">วิธีใช้งาน</h2>
        <div class="text-center font-weight-light">
            <?php echo wpautop(config('howto.caption', false), true) ?>
        </div>
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <ul class="list-step-order mb-4">
                    <?php foreach ((array)config('howto.step', false) as $i => $item) : ?>
                        <li><?= $i + 1 ?></li>
                    <?php endforeach; ?>
                </ul>
                <div class="row align-items-stretch mb-4">
                    <?php foreach ((array)config('howto.step', false) as $i => $item) : ?>
                        <div class="col-lg-3 col-6 mb-4 mb-lg-0 d-flex align-items-stretch">
                            <div class="card border-0 shadow w-100">
                                <div class="card-body p-lg-5 text-center">
                                    <img src="<?php echo  $item['icon']['url'] ?>" class="w-xl-50 w-75 mb-3">
                                    <div class="h5 mb-0"><?php echo $item['title'] ?></div>
                                    <p class="mb-0 text-muted font-weight-light"><?php echo $item['caption'] ?></p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="text-center text-muted">
                    *ทั้งนี้ในส่วนของล็อกเกอร์ เราตั้งอยู่ในคอนโด, อาคารสำนักงาน, และร้านสะดวกซื้อ ให้คุณสามารถเข้าใช้ได้ 24 ชั่วโมง
                </div>
            </div>
        </div>

    </div>
</div>
<div class="block-section block-section-xl pb-0">
    <div class="container">
        <div class="row align-items-center justify-content-center">
            <div class="col-lg-3">
                <div class="row">
                    <div class="col-lg-12 col-sm-6">
                        <div class="mb-4 mb-lg-5 text-center">
                            <img src="<?= $data['easywatch_step'][0]['icon']['url']; ?>" class="w-25 mb-3">
                            <div class="h5"><?= $data['easywatch_step'][0]['title']; ?></div>
                            <div class="text-muted font-weight-light"><?= $data['easywatch_step'][0]['caption']; ?></div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-6">
                        <div class="text-center mb-md-0 mb-4">
                            <img src="<?= $data['easywatch_step'][1]['icon']['url']; ?>" class="w-25 mb-3">
                            <div class="h5"><?= $data['easywatch_step'][1]['title']; ?></div>
                            <div class="text-muted font-weight-light"><?= $data['easywatch_step'][1]['caption']; ?></div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="col-lg-4 d-none d-lg-block text-center">
                <img src="<?php asset('images/icons/howto_0.png'); ?>" class="w-xl-75 w-100 mb-3">
            </div>
            <div class="col-lg-3">
                <div class="row">
                    <div class="col-lg-12 col-sm-6">
                        <div class="mb-4 mb-lg-5 text-center">
                            <img src="<?= $data['easywatch_step'][2]['icon']['url']; ?>" class="w-25 mb-3">
                            <div class="h5"><?= $data['easywatch_step'][2]['title']; ?></div>
                            <div class="text-muted font-weight-light"><?= $data['easywatch_step'][2]['caption']; ?></div>
                        </div>
                    </div>
                    <div class="col-lg-12 col-sm-6">
                        <div class="text-center">
                            <img src="<?= $data['easywatch_step'][3]['icon']['url']; ?>" class="w-25 mb-3">
                            <div class="h5"><?= $data['easywatch_step'][3]['title']; ?></div>
                            <div class="text-muted font-weight-light"><?= $data['easywatch_step'][3]['caption']; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="block-section block-section-xl pb-0">
    <div class="container">
        <h2 class="h1 mb-3 text-center">ขนาดและราคา</h2>
        <p class="text-center font-weight-light mb-4">
            ช่วยอำนวยความสะดวกให้แก่ลูกค้า โดยที่ลูกค้าสามารถตรวจสอบติดตามได้ว่าขณะนี้เสื้อผ้าที่ส่งซักนั้นอยู่ขั้นตอนไหนได้
        </p>

        <div class="row no-gutters justify-content-center mb-4">
            <div class="col-lg-10">
                <div class="row no-gutters">
                    <?php $items = config('pricing.items', false); ?>
                    <?php foreach ((array)$items[0]['types'] as $k => $item) : ?>
                        <?php if ($k < 4) : ?>
                            <div class="col-lg-3 col-6 text-center mb-3">
                                <img src="<?php echo $item['url'] ?>" class="w-100">
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div class="text-center">
            <a href="/pricing" class="btn btn-outline-primary btn-lg mb-3 px-5">สินค้าเพิ่มเติม</a>
        </div>
        <div class="text-center text-muted">
            *ทั้งนี้ในส่วนของล็อกเกอร์ เราตั้งอยู่ในคอนโด, อาคารสำนักงาน, และร้านสะดวกซื้อ ให้คุณสามารถเข้าใช้ได้ 24 ชั่วโมง
        </div>
    </div>
</div>

<div class="block-section block-section-xl">
    <div class="container">
        <h2 class="h1 mb-4 text-center">สาขา</h2>

        <div class="row">
            <?php foreach ((array)config('branch.branchs', false) as $i => $item) : ?>
                <?php if ($i < 4) : ?>
                    <div class="col-sm-6 mb-4">
                        <div class="card border-0 shadow">
                            <div class="card-body pl-md-0">
                                <div class="row align-items-center">
                                    <div class="col-lg-4 col-md-3 mb-3 mb-md-0">
                                        <img src="<?php echo $item['image']['url'] ?>" class="w-100">
                                    </div>
                                    <div class="col-lg-8 col-md-9 text-center text-sm-left">
                                        <div class="h3 mb-0 text-primary text-uppercase"><?php echo $item['name']; ?></div>
                                        <div class="text-muted mb-3"><?php echo $item['open_date']; ?></div>
                                        <a target="_blank" href="<?php echo $item['google_map']; ?>" class="text-danger">Click to Google Maps</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>

        </div>

    </div>
</div>

<?= $data['google_map']; ?>

<div class="container pb-5">
    <div class="py-4">
        <div class="text-center">
            <a href="<?= $data['find_locker_link']; ?>" class="btn btn-primary btn-lg mb-3 px-5">ค้นหาล็อกเกอร์ใกล้คุณ</a>
        </div>
    </div>
</div>
<?php get_footer();
