<?php
get_header();

$category = get_queried_object();
$cat_meta = get_option("category_{$category->term_id}");
$image = wp_get_attachment_image_src($cat_meta['image_id'], 'full');

?>

    <div class="container">
        <div class="page-cover ">
            <h1 class="mb-4 block-section-title text-center h1"><?php echo $cat_meta['title'] ?></h1>
            <div class="page-content">
				<?php echo wpautop(category_description($category->term_id), true) ?>
            </div>
        </div>
    </div>

    <div class="block-section bg-secondary">
        <div class="container">
            <div class="blog">
                <div class="row row-sm">
					<?php while (have_posts()) : the_post(); ?>
                        <div class="col-lg-4 col-md-6 mb-4">
							<?php get_template_part('part/item'); ?>
                        </div>
					<?php endwhile; ?>
                </div>
            </div>

        </div>
    </div>

<?php get_footer();
