<?php
/*
 * Template Name: Faq
 */

get_header();
the_post();
$data = get_fields();

$tabs = $data['faq_lists'];


?>
<div class="block-section">
    <div class="container">
        <div class="text-center">
            <h1 class="mb-4"><?php the_title(); ?></h1>
        </div>
        <ul class="nav nav-tabs justify-content-start mb-4 text-md-center text-left" role="tablist">
            <?php foreach ($tabs as $k => $tab) : ?>
                <li class="nav-item mb-3 w-100 w-lg-auto">
                    <a class="nav-link bg-white <?= (!$k) ? 'active' : '' ?>" data-toggle="tab" href="#tab-<?= $k ?>" role="tab" aria-controls="tab-1" aria-selected="true"><?= $tab['title']; ?></a>
                </li>
            <?php endforeach; ?>
        </ul>

        <div class="mb-2 pl-lg-3 text-muted">* คำอธิบาย</div>
        <div class="tab-content" id="myTabContent">
            <?php foreach ($tabs as $k => $tab) : ?>
                <div class="tab-pane fade <?= (!$k) ? 'show active' : '' ?>" id="tab-<?= $k ?>" role="tabpanel" aria-labelledby="tab-<?= $k ?>">
                    <div class="card border-0 bg-gray mb-4">
                        <div class="card-body p-lg-5">
                            <?php echo wpautop($tab['detail'], true) ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>
    </div>
</div>

<?php get_footer();
