<?php
/*
 * Template Name: Franchising
 */

get_header();
the_post();
$data = get_fields();
?>

<div class="block-section pb-0">
    <div class="container">
        <div class="text-center">
            <h1><?php the_title(); ?></h1>
            <p class="mb-4">
                ประเภทแฟรนไชน์
            </p>

            <div class="line-connect px-lg-3 mb-4">
                <div class="row justify-content-between">
                    <?php foreach ($data['franchising'] as $k => $item) : ?>
                        <div class="col-md-3 mb-4 mb-lg-0">
                            <img src="<?= $item['url'] ?>" class="w-100">
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="text-center text-muted">ร่วมเป็นส่วนหนึ่งของแฟรนไชน์ที่ใครๆ ก็พูดถึงเพียง 120,000 บาทกับพื้นที่ 1 ตารางเมตร รับส่วนแบ่งรายได้ซักแห้ง 30% ซักอบรีด 15% ทุกเดือน*</div>
        </div>
    </div>
</div>
<div class="block-section mb-4">
    <div class="container">
        <h2 class="h1 text-center">สมัครสมาชิก</h2>
        <div class="row align-items-center">
            <div class="col-md-5 mb-4 mb-md-0">
                <div class="h4 mb-4 text-seconary">กรอกข้อมูลเพื่อลงทะเบียน</div>
                <form id="register-form">
                    <div class="form-group">
                        <input type="text" name="name" class="form-control" placeholder="ชื่อ">
                    </div>
                    <div class="form-group">
                        <input type="text" name="email" class="form-control" placeholder="อีเมล์">
                    </div>
                    <div class="form-group">
                        <input type="text" name="phone" class="form-control" placeholder="เบอร์โทร">
                    </div>
                    <div class="form-group">
                        <label>ท่านมีตำแหน่งที่ตั้งล็อกเกอร์พร้อมใช้หรือไม่</label>
                        <div class="d-flex align-items-center">
                            <div class="mr-3">
                                <input type="radio" name="locker" value="1" checked>
                                <span class="text-seconary">มีแล้ว</span>
                            </div>
                            <div class="mr-3">
                                <input type="radio" name="locker" value="0">
                                <span class="text-seconary">ยังไม่มี</span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>หากมีแล้วกรุณาระบุที่ตั้งของล็อกเกอร์</label>
                        <input type="text" name="place" class="form-control" placeholder="ชื่อของสถานที่ตั้งของล็อกเกอร์">
                    </div>
                    <div class="form-group">
                        <button type="button" class="btn btn-primary send">ส่งข้อมูล</button>
                    </div>
                </form>
            </div>
            <div class="col-md-7 d-none d-md-block">
                <img src="<?php asset('images/register.png') ?>" class="w-100">
            </div>
        </div>
    </div>
</div>

<?php get_footer();
