<?php
/*
 * Template Name: How To
 */

get_header();
the_post();
$data = get_fields();
?>

<div class="block-section">
    <div class="container">
        <div class="text-center">
            <h1 class="mb-4"><?php the_title(); ?></h1>
            <div class="videoWrapper mb-5 d-none">
                <?= $data['youtube']; ?>
            </div>
            <!-- <div class="text-center mb-4">
                <div class="d-flex flex-wrap justify-content-center">
                    <a href="" class="btn btn-primary btn-lg w-100 w-lg-auto px-5 mb-3 mr-lg-3">สำหรับฝากของ</a>
                    <a href="" class="btn btn-outline-primary btn-lg w-100 w-lg-auto mb-3 px-5">สำหรับเสื้อผ้า</a>
                </div>
            </div> -->


            <ul class="nav nav-tabs justify-content-center mb-4" id="myTab" role="tablist">
                <li class="nav-item mb-3 w-100 w-lg-auto">
                    <a class="nav-link active" data-toggle="tab" href="#tab-1" role="tab" aria-controls="tab-1" aria-selected="true">สำหรับฝากของ</a>
                </li>
                <li class="nav-item mb-3 w-100 w-lg-auto">
                    <a class="nav-link" data-toggle="tab" href="#tab-2" role="tab" aria-controls="tab-2" aria-selected="true">สำหรับเสื้อผ้า</a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="tab-1" role="tabpanel" aria-labelledby="tab-1">
                    <div class="text-center font-weight-light mb-4 pb-2">
                        <?php echo wpautop($data['caption'], true) ?>
                    </div>
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <ul class="list-step-order mb-4">
                                <?php foreach ((array)$data['step'] as $i => $item) : ?>
                                    <li><?= $i + 1 ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="row align-items-stretch mb-4">
                                <?php foreach ((array)$data['step'] as $i => $item) : ?>
                                    <div class="col-lg-3 col-6 mb-4 mb-lg-0 d-flex align-items-stretch">
                                        <div class="card border-0 shadow w-100">
                                            <div class="card-body p-lg-5 text-center">
                                                <img src="<?php echo  $item['icon']['url'] ?>" class="w-xl-50 w-75 mb-3">
                                                <div class="h5 mb-0"><?php echo $item['title'] ?></div>
                                                <p class="mb-0 text-muted font-weight-light"><?php echo $item['caption'] ?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>

                            </div>
                            <div class="text-center text-muted">
                                *ทั้งนี้ในส่วนของล็อกเกอร์ เราตั้งอยู่ในคอนโด, อาคารสำนักงาน, และร้านสะดวกซื้อ ให้คุณสามารถเข้าใช้ได้ 24 ชั่วโมง
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="tab-2" role="tabpanel" aria-labelledby="tab-2">
                    <p class="text-center">
                        <?php echo wpautop($data['caption_2'], true) ?>
                    </p>
                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <ul class="list-step-order mb-4">
                                <?php foreach ((array)$data['step_clothing'] as $i => $item) : ?>
                                    <li><?= $i + 1 ?></li>
                                <?php endforeach; ?>
                            </ul>
                            <div class="row align-items-stretch mb-4">
                                <?php foreach ((array)$data['step_clothing'] as $i => $item) : ?>
                                    <div class="col-lg-3 col-6 mb-4 mb-lg-0 d-flex align-items-stretch">
                                        <div class="card border-0 shadow w-100">
                                            <div class="card-body p-lg-5 text-center">
                                                <img src="<?php echo  $item['icon']['url'] ?>" class="w-xl-50 w-75 mb-3">
                                                <div class="h5 mb-0"><?php echo $item['title'] ?></div>
                                                <p class="mb-0 text-muted"><?php echo $item['caption'] ?></p>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>

                            </div>
                            <div class="text-center text-muted">
                                *ทั้งนี้ในส่วนของล็อกเกอร์ เราตั้งอยู่ในคอนโด, อาคารสำนักงาน, และร้านสะดวกซื้อ ให้คุณสามารถเข้าใช้ได้ 24 ชั่วโมง
                            </div>
                        </div>
                    </div>
                </div>
            </div>



        </div>
    </div>
</div>


<?php get_footer();
