<?php
/*
 * Template Name: Pricing
 */

get_header();
the_post();
$data = get_fields();
?>

<div class="block-section pb-0">
    <div class="container">
        <div class="text-center">
            <h1 class="mb-4"><?php the_title(); ?></h1>
            <div class="mb-5">
                <?php echo wpautop($data['caption'], true) ?>
            </div>


            <ul class="nav nav-tabs justify-content-center mb-4" id="myTab" role="tablist">
                <?php foreach ($data['items'] as $k => $item) : ?>
                    <li class="nav-item mb-3 w-100 w-lg-auto">
                        <a class="nav-link <?= (!$k) ? 'active' : '' ?>" data-toggle="tab" href="#tab-<?= $k ?>" role="tab" aria-controls="tab-<?= $k ?>" aria-selected="true"><?= $item['type_name']; ?></a>
                    </li>
                <?php endforeach; ?>
            </ul>
            <div class="tab-content mb-4" id="myTabContent">
                <div class="tab-pane fade show active" id="tab-0" role="tabpanel" aria-labelledby="tab-1">
                    <div class="row no-gutters justify-content-center">
                        <div class="col-lg-9">

                            <div class="row">
                                <?php foreach ($data['items'][0]['types'] as $k => $item) : ?>
                                    <div class="col-md-4 col-6 text-center mb-3">
                                        <img src="<?php echo $item['url'] ?>" class="w-100">
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php foreach ($data['items'] as $k => $item) : ?>
                    <?php if ($k) : ?>
                        <div class="tab-pane fade" id="tab-<?= $k ?>" role="tabpanel" aria-labelledby="tab-2">
                            <div class="row no-gutters justify-content-center">
                                <div class="col-lg-9">
                                    <div class="row">
                                        <?php foreach ($item['types'] as $kk => $i) : ?>
                                            <div class="col-md-4 col-sm-6 text-center mb-3">
                                                <img src="<?php echo $i['url'] ?>" class="w-100">
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>

            <div class="row  justify-content-center">
                <div class="col-lg-11">
                    <div class="row no-gutters align-items-center">
                        <div class="col-lg-4 d-none d-lg-block">
                            <div class="text-center -indent-right position-relative" style="z-index: 100;">
                                <img src="<?php asset('images/men-point.png'); ?>" class="w-100">
                            </div>
                        </div>
                        <div class="col-lg-8">
                            <div class="text-left font-weight-light">
                                <div class="card border-0 bg-gray mb-4">
                                    <div class="card-body  text-muted px-lg-5 py-lg-4" style="font-size: 18px;">
                                        <?php echo wpautop($data['note'], true) ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>


<?php get_footer();
