<?php global $error_message; ?>
<div class="login-form" id="login-form">
    <div class="text-center mb-3">
		<?php $img = config('setting.main_logo', false); ?>
        <a href="<?php echo get_home_url(); ?>"><img src="<?php echo $img['url'] ?>" alt="<?php echo $img['alt'] ? $img['alt'] : $img['name']; ?>" width="200"></a>
    </div>

	<?php if ($error_message) : ?>
        <div class="alert alert-danger text-center mb-3"><?php echo $error_message; ?></div>
	<?php endif ?>


    <form method="post">
        <input type="hidden" name="action" value="login">
        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text"><i class="mdi mdi-account"></i></span>
            </div>
            <input type="text" class="form-control" name="username" placeholder="Username" aria-label="Username" aria-describedby="basic-addon1">
        </div>
        <div class="input-group mb-3">
            <div class="input-group-prepend">
                <span class="input-group-text"><i class="mdi mdi-key"></i></span>
            </div>
            <input type="password" class="form-control" name="password" placeholder="Password" aria-label="Password" aria-describedby="basic-addon1">
        </div>
        <div class="">
            <button class="btn btn-primary btn-block mb-3"><i class="mdi mdi-lock-open"></i>เข้าสู่ระบบ</button>
            <div class="row row-sm">
                <div class="col-sm-6">
                    <a href="<?php config('setting.register_url'); ?>" target="_blank" class="btn btn-danger-x btn-block mb-3 mb-sm-0"><i class="mdi mdi-account-plus"></i>สมัครสมาชิก</a>
                </div>
                <div class="col-sm-6">
                    <a href="<?php config('setting.money_url'); ?>" target="_blank" class="btn btn-success btn-block"><i class="mdi mdi-coins"></i>ลิ้งรับทรัพย์</a>
                </div>
            </div>

        </div>
    </form>
</div>
